/*
 * Decompiled with CFR 0.152.
 */
package potionstudios.byg.common.world.surfacerules.rulesource;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_5216;
import net.minecraft.class_5819;
import net.minecraft.class_6686;
import net.minecraft.class_6724;
import potionstudios.byg.mixin.access.SurfaceRuleContextAccess;
import potionstudios.byg.mixin.access.SurfaceSystemAccess;

public final class BandsRuleSource
implements class_6686.class_6708 {
    public static final Codec<BandsRuleSource> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)class_2680.field_24734.listOf().fieldOf("states").forGetter(bandsRuleSource -> Arrays.asList(bandsRuleSource.bandStates))).apply((Applicative)builder, BandsRuleSource::new));
    private final class_2680[] bandStates = new class_2680[8];
    @Nullable
    private class_2680[] generatedBands = null;

    public BandsRuleSource(List<class_2680> bandStates) {
        this((class_2680[])bandStates.toArray(class_2680[]::new));
    }

    public BandsRuleSource(class_2680[] bandStates) {
        for (int i = 0; i < this.bandStates.length; ++i) {
            this.bandStates[i] = bandStates[Math.min(i, bandStates.length - 1)];
        }
    }

    public Codec<? extends class_6686.class_6708> method_39061() {
        return CODEC;
    }

    public class_6686.class_6715 apply(class_6686.class_6694 context) {
        class_6724 system = ((SurfaceRuleContextAccess)context).byg_getSystem();
        if (this.generatedBands == null) {
            this.generatedBands = this.generateBands(((SurfaceSystemAccess)system).byg_getRandomFactory().method_39000(new class_2960("clay_bands")));
        }
        return (x, y, z) -> BandsRuleSource.getBand(x, y, z, this.generatedBands, ((SurfaceSystemAccess)system).byg_getClayBandsOffsetNoise());
    }

    private static class_2680 getBand(int x, int y, int z, class_2680[] bands, class_5216 offsetNoise) {
        int noiseVal = (int)Math.round(offsetNoise.method_27406((double)x, 0.0, (double)z) * 4.0);
        return bands[(y + noiseVal + bands.length) % bands.length];
    }

    private class_2680[] generateBands(class_5819 p_189965_) {
        Object[] ablockstate = new class_2680[192];
        Arrays.fill(ablockstate, this.bandStates[0]);
        for (int k = 0; k < ablockstate.length; ++k) {
            if ((k += p_189965_.nextInt(5) + 1) >= ablockstate.length) continue;
            ablockstate[k] = this.bandStates[1];
        }
        SurfaceSystemAccess.byg_invokeMakeBands(p_189965_, (class_2680[])ablockstate, 1, this.bandStates[2]);
        SurfaceSystemAccess.byg_invokeMakeBands(p_189965_, (class_2680[])ablockstate, 2, this.bandStates[3]);
        SurfaceSystemAccess.byg_invokeMakeBands(p_189965_, (class_2680[])ablockstate, 1, this.bandStates[4]);
        int l = p_189965_.method_39332(9, 15);
        int i = 0;
        for (int j = 0; i < l && j < ablockstate.length; ++i, j += p_189965_.nextInt(16) + 4) {
            ablockstate[j] = this.bandStates[5];
            class_2680 state6 = this.bandStates[6];
            if (j - 1 > 0 && p_189965_.nextBoolean()) {
                ablockstate[j - 1] = state6;
            }
            if (j + 1 >= ablockstate.length || !p_189965_.nextBoolean()) continue;
            ablockstate[j + 1] = state6;
        }
        return ablockstate;
    }

    public class_2680[] bandStates() {
        return this.bandStates;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        BandsRuleSource that = (BandsRuleSource)obj;
        return Objects.equals(this.bandStates, that.bandStates);
    }

    public int hashCode() {
        return Objects.hash(this.bandStates);
    }

    public String toString() {
        return "ShatteredGlacierIceBands[bandStates=" + Arrays.toString(this.bandStates) + "]";
    }
}

